<?php

namespace App\Models\Product;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductAllowedAttribute extends Model 
{

    protected $table = 'products_allowed_attributes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function product_abstraction()
    {
        return $this->belongsTo('App\Models\Product\ProductAbstraction', 'product_abstraction_id');
    }

    public function product_attribute()
    {
        return $this->belongsTo('App\Models\Product\ProductAttribute', 'product_attribute_id');
    }

}